//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 9 materials and 52 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/26/2001    (26.02.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from Truth 2.mdl:
This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <    -30.893,     -65.591,      40.859>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33838,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         18.35975    // Vertical      13.770
  look_at   <     21.904,     -23.310,       1.505>
  // Focal blur settings
  focal_point  <21.904, -23.310, 1.505> // Always Lookat
  aperture     1.0
  blur_samples 27
  confidence   0.935
  variance     0.007667
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  translate  <41.531064, -57.912069, 33.815533>
}

#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  2.0*z
}


//
// ********  MATERIALS  *******
//

#include "the truth.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Round_Wall_End2 = difference {
  cylinder { // Round_Part5
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.0>
    translate  <4.0, -3.0, 0.0>
    material {
      Tinny_Brass
      // Transform to parent space
    }
  }
  box { // Removal_Cube_for_round_wall2
    <-1, -1, -1>, <1, 1, 1>
    no_shadow
    scale <0.1, 0.2, 1.001>
    translate  <4.1, -3.0, 1.0>
  }
  material {
    Tinny_Brass
  }
}
#declare Rounded_Wall2 = union {
  box { // Round_Wall_Part2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 1.0>
    translate  <3.9, -1.0, 1.0>
  }
  object { Round_Wall_End2 }
  no_shadow
}
#declare Top3 = union {
  box { // Short_Wall2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-3.9, 0.0, 1.0>
  }
  box { // Back_Wall2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.1, 1.0>
    translate  <0.0, 0.9, 1.0>
  }
  object { Rounded_Wall2 }
}
#declare Round_Wall_End1 = difference {
  cylinder { // Round_Part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.0>
    translate  <4.0, -3.0, 0.0>
    material {
      Tinny_Brass
      // Transform to parent space
    }
  }
  box { // Removal_Cube_for_round_wall1
    <-1, -1, -1>, <1, 1, 1>
    no_shadow
    scale <0.1, 0.2, 1.001>
    translate  <4.1, -3.0, 1.0>
  }
  material {
    Tinny_Brass
  }
}
#declare Rounded_Wall1 = union {
  box { // Round_Wall_Part1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.0, 1.0>
    translate  <3.9, -1.0, 1.0>
  }
  object { Round_Wall_End1 }
  no_shadow
}
#declare Top2 = union {
  box { // Short_Wall1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
    translate  <-3.9, 0.0, 1.0>
  }
  box { // Back_Wall1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.1, 1.0>
    translate  <0.0, 0.9, 1.0>
  }
  object { Rounded_Wall1 }
}


#declare Cone002 = object {
  cone { // Cone002
    <0,0,0>, 0.1, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.1>
    rotate -180.0*x
    translate  2.2*z
  }
}




//
// ********  OBJECTS  *******
//



plane { // Plane001
  z,0
  material {
    Grass
  }
  translate  -12.0*z
}


#declare Long_Part2 = union {
  box { // Desk2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 0.1>
  }
  box { // Side_Desk2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.1>
    translate  <3.0, -2.0, 0.0>
  }
}
#declare Round_Corner2 = difference {
  cylinder { // Round_Part4
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.2>
    translate  <4.0, -3.0, -0.1>
  }
  box { // Removeal_Area2
    <-1, -1, -1>, <1, 1, 1>
    no_shadow
    scale <1.0, 2.0, 0.1001>
    translate  <5.0, -3.0, 0.0>
  }
}
#declare Inside_Curve = difference {
  box { // Side_Desk3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.65, 0.65, 0.1>
    translate  <1.4, -1.6, 0.0>
  }
  cylinder { // Inside_Removal
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 0.25>
    translate  <0.756805, -2.2581, -0.125>
  }
}
#declare Horizontal_Parts2 = union {
  object { Long_Part2 }
  object { Round_Corner2 }
  object { Inside_Curve }
  material {
    RoughStone
  }
}
#declare Vertical_Parts2 = union {
  object { Top3 }
  object { // Bottom3 -> Top3
    Top3
    translate  -2.0*z
  }
}
#declare Shelf2 = union {
  box { // Shelf_End2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.5, 0.5>
    translate  <-0.05, 0.5, 1.5>
  }
  box { // Shelf_Bottom2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    translate  <-2.0, 0.5, 1.05>
  }
  material {
    Tinny_Brass
  }
}
#declare Office_Desk_CLeftD2 = union {
  object { Horizontal_Parts2 }
  object { Vertical_Parts2 }
  object { Shelf2 }
  material {
    BallWood
  }
}
#declare Long_Part1 = union {
  box { // Desk1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 1.0, 0.1>
  }
  box { // Side_Desk1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.1>
    translate  <3.0, -2.0, 0.0>
  }
}
#declare Round_Corner1 = difference {
  cylinder { // Round_Part1
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.2>
    translate  <4.0, -3.0, -0.1>
  }
  box { // Removeal_Area1
    <-1, -1, -1>, <1, 1, 1>
    no_shadow
    scale <1.0, 2.0, 0.1001>
    translate  <5.0, -3.0, 0.0>
  }
}
#declare Inside_Curve1 = difference {
  box { // Side_Desk4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.65, 0.65, 0.1>
    translate  <1.4, -1.6, 0.0>
  }
  cylinder { // Inside_Removal1
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 0.25>
    translate  <0.756805, -2.2581, -0.125>
  }
  rotate <-0.0, -0.0, 0.0>
}
#declare Horizontal_Parts1 = union {
  object { Long_Part1 }
  object { Round_Corner1 }
  object { Inside_Curve1 }
  material {
    RoughStone
  }
}
#declare Vertical_Parts1 = union {
  object { Top2 }
  object { // Bottom2 -> Top2
    Top2
    translate  -2.0*z
  }
}
#declare Shelf1 = union {
  box { // Shelf_End1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.5, 0.5>
    translate  <-0.05, 0.5, 1.5>
  }
  box { // Shelf_Bottom1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    translate  <-2.0, 0.5, 1.05>
  }
  rotate <0.0, -180.0, -180.0>
  translate  1.0*y
}
#declare Office_Desk_CRightD = union {
  object { Horizontal_Parts1 }
  object { Vertical_Parts1 }
  object { Shelf1 }
  material {
    BallWood
  }
  rotate <180.0, 0.0, 180.0>
  translate  8.0*x
}
union { // Office
  object { Office_Desk_CLeftD2 }
  object { Office_Desk_CRightD }
  scale 6.0
}


#declare Bottom_Group = union {
  cylinder { // BackRound
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -90.0*y
    translate  <5.0, 1.0, 0.0>
  }
  cylinder { // FrontRound
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -90.0*y
    translate  <5.0, -1.0, 0.0>
  }
  box { // Bottom
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 1.0>
    rotate -90.0*x
  }
  translate  1.0*y
}
#declare Front_Group = union {
  cylinder { // TopRound
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 10.0>
    rotate -90.0*y
    translate  <5.0, 0.0, 2.0>
  }
  box { // Front
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 1.0>
    translate  1.0*z
  }
  text {   // Truth_Text
    ttf      "C:\WINNT\Fonts\Arial.ttf",
    "Truth",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Truth_M_Red
    }
    scale <4.0, 2.0, 1.0>
    rotate 90.0*x
    translate  <-4.5, -0.05, 0.3>
  }

  rotate -30.0*x
}
union { // Truth_Sign
  object { Bottom_Group }
  object { Front_Group }
  material {
    Candelar_Text
  }
  translate  <23.811254, -28.279929, 0.727729>
}


//
// Include file contains 'Dish'
//
#include "the truth.in1"
object {   // Dish
  Dish_Raw
  material {
    White_China
  }
  translate  <24.129048, -23.045623, 1.6>
}


union { // Truth_Group
  sphere { // Truth_Sphere
    <0,0,0>,1
    material {
      Truth_Map
    }
    scale <1.0, 2.0, 2.0>
  }
  scale 0.3
  rotate <0.0, -90.0, -180.0>
  translate  <23.672124, -23.782975, 1.162117>
}


#declare Light_n_Shade = union {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 3.0
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.4>
    rotate -90.0*y
    translate  0.2*x
  }
  object { Light002 }
  // Scaling fixed
  // Rot X limited (-100.0 to   100.0)
  // Translation fixed
  rotate -100.0*x
  translate  10.0*z
}
#declare Light_ForeArm = union {
  cylinder { // Arm_Pivot_Point1
    <0,0,1>, <0,0,0>, 1 
    material {
      Truth_Text_M_White
    }
    scale <0.2, 0.2, 0.4>
    rotate -90.0*y
    translate  0.2*x
  }
  cylinder { // Arm_Length1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
  }
  object { Light_n_Shade }
  // Scaling fixed
  // Rot X limited (-135.0 to   135.0)
  // Translation fixed
  rotate -55.326221*x
  translate  10.0*z
}
#declare Light_Arm = union {
  cylinder { // Arm_Pivot_Point
    <0,0,1>, <0,0,0>, 1 
    material {
      Truth_Text_M_White
    }
    scale <0.2, 0.2, 0.4>
    rotate -90.0*y
    translate  0.2*x
  }
  cylinder { // Arm_Length
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
  }
  object { Light_ForeArm }
  // Scaling fixed
  // Rot X limited (-90.0 to   90.0)
  // Translation fixed
  rotate -36.430279*x
}
#declare Arm_Base = difference {
  cylinder { // Light_Arm_Base
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.7>
    translate  -0.5*z
  }
  box { // Base_Removal
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.0, 1.0>
    translate  0.8*z
  }
  material {
    White_China
  }
  translate  1.7*z
}
#declare Arm_Cone_Base = intersection {
  object { Arm_Base }
  object { Cone002 }
  translate  -1.7*z
}
#declare Arm_Base_Group = union {
  object { Light_Arm }
  object { Arm_Cone_Base }
  // Scaling fixed
  // Rot Z limited (-360.0 to   0.0)
  // Translation fixed
  rotate -144.398041*z
  translate  1.7*z
}
#declare Base_Shape = intersection {
  cylinder { // Light_Base_Center
    <0,0,1>, <0,0,0>, 1 
    translate  0.1*z
  }
  object { // Cone004 -> Cone002
    Cone002
    rotate -0.0*x
  }
}
#declare Light_Base = union {
  cylinder { // Light_Base_Main
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 0.1>
  }
  cylinder { // Light_Base_Rod
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.4>
    translate  0.1*z
  }
  object { Arm_Base_Group }
  object { Base_Shape }
  material {
    White_China
  }
  // All transformations fixed
}
union { // Arm_Light
  object { Light_Base }
  scale 0.7
  translate  <16.88815, -18.34762, 0.75>
}


